﻿//////////////////////////////////////////////
// ResourceManagerWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkResourcesWrap
{
	class DLL_ASTRAEUS_EXPORT ResourceManagerWrapper final
	{
		public :

			// Mise en place environnement
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks qui seront appelés suivant les fonctions
			// Working path
			static nkScripts::OutputValue getWorkingPath (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getWorkingPathAbsolute (const nkScripts::DataStack& stack) ;

			// Launched path
			static nkScripts::OutputValue getLaunchedPath (const nkScripts::DataStack& stack) ;

			// Traductions
			static nkScripts::OutputValue getRelativeFromAbsolute (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getAbsoluteFromRelative (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getRelativeFromWorkingDir (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getAbsoluteFromWorkingDir (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getFromWorkingDirFromRelative (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getFromWorkingDirFromAbsolute (const nkScripts::DataStack& stack) ;

			// Checks
			static nkScripts::OutputValue checkFileExists (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue checkFolderExists (const nkScripts::DataStack& stack) ;

			// Loading
			static nkScripts::OutputValue loadFileIntoMemory (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue saveFileToDisk (const nkScripts::DataStack& stack) ;
	} ;
}